/*
 * Main.java
 *
 * Created on 29. November 2006, 23:33
 *
 * Written by:
 * Frank Bicking: 504628
 * Martin Schrder: 502301
 *
 * Group: Bort
 */

package constraintprop;

/**
 *
 * @author Martin Schrder, 502301
 * @author Frank Bicking, 504628
 */
public class Main {
    
    /* The properties of the camera */
    public static final int cameraPixelHoriz = 208;
    public static final int cameraPixelVert = 160;
    public static final double cameraAngleHoriz = 55;
    public static final double cameraAngleVert = 44;
    /* The actual input constraints */
    public static final LandmarkDefinition landmark1 = new LandmarkDefinition(
            Constraint.FlagNW,  //Type
            21.68,              //Bearing
            //44                  //Size in Pixel
            13
            );
    public static final LandmarkDefinition landmark2 = new LandmarkDefinition(
            Constraint.FlagSW,  //Type
            102.3,              //Bearing
            //115                 //Size in Pixel
            10
            );
    public static final LandmarkDefinition landmark3 = new LandmarkDefinition(
            Constraint.FlagNE,  //Type
            -72.42,             //Bearing
            //75                  //Size in Pixel
            10
            );
    
    /** Creates a new instance of Main */
    public Main() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        //Creating the new Constraint with the given camera properties
        Constraint cons = new Constraint(cameraAngleHoriz, cameraAngleVert,
                cameraPixelHoriz, cameraPixelVert);
        //Now constraing the position and angle with an error in percent.
        cons.constrain(landmark1.type, landmark1.bearing, landmark1.size, 5.0);
        System.out.println("Intervals after first landmark:\n" + cons.toString() + "\n");
        cons.constrain(landmark2.type, landmark2.bearing, landmark2.size, 5.0);
        System.out.println("Intervals after second landmark:\n" + cons.toString() + "\n");
        cons.constrain(landmark3.type, landmark3.bearing, landmark3.size, 5.0);
        System.out.println("Intervals after third landmark:\n" + cons.toString() + "\n");
    }
}

/**
 * Defines a landmark.
 * Type is an int you can read from the constants of the Constraint-class.
 * Bearing is the angle the object is seen at, including the camera offset of
 * 90 if camera left, 0 if camera front and -90 if camera right.
 * Size is the horizontal size of the object in pixel.
 */
final class LandmarkDefinition {
    public int type;
    public double bearing;
    public int size;
    
    public LandmarkDefinition(int type, double bearing, int size) {
        this.type = type;
        this.bearing = bearing;
        this.size = size;
    }
}
